package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.enums.TracingStatusType;
import gov.va.med.mhv.usermgmt.data.model.MpiEvent;
import gov.va.med.mhv.usermgmt.data.model.Trace;
import gov.va.med.mhv.usermgmt.data.repository.MpiEventsRepository;
import gov.va.med.mhv.usermgmt.data.repository.TraceRepository;
import gov.va.med.mhv.usermgmt.main.registry.BaseMessage;
import gov.va.med.mhv.usermgmt.main.registry.EventId;
import gov.va.med.mhv.usermgmt.main.registry.Patient;
import gov.va.med.mhv.usermgmt.service.EventTracingService;

@Component
public class EventTracingServiceImpl implements EventTracingService {

    public static final String OUT="out";
    public static final String IN="in";

    @Autowired
    private MpiEventsRepository mpiEventsRepository;
    
    @Autowired
    private TraceRepository traceRepository;
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#traceEvent(gov.va.med.mhv.usermgmt.main.registry.EventId, gov.va.med.mhv.usermgmt.main.registry.Patient, java.lang.String, gov.va.med.mhv.usermgmt.main.registry.BaseMessage)
	 */
	@Override
	public Trace traceEvent(EventId id, Patient patient, String direction, 
        BaseMessage data) 
    {
		return traceEvent(id, null, patient, direction, data);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#traceEvent(gov.va.med.mhv.usermgmt.main.registry.EventId, java.lang.Long, gov.va.med.mhv.usermgmt.main.registry.Patient, java.lang.String, gov.va.med.mhv.usermgmt.main.registry.BaseMessage)
	 */
	@Override
	public Trace traceEvent(EventId id, Long userId, Patient patient, String direction, BaseMessage data)
	{
		Date date = new Date();
		MpiEvent event = null;
		if (id.getId() != null) {
			event = mpiEventsRepository.findOne(id.getId());
			if (userId != null) {
				event.setUserId(userId);
			}
		} else {
			// The event being traced has no eventId, but it may exist in
			// the MPI_EVENTS table with a correlationId
			if (id.getCorrelationId() != null) {
				List<MpiEvent> events = mpiEventsRepository.findByCorrelationId(id.getCorrelationId());
				if (events.size() > 0) {
					event = events.get(0);
				}
			}
			if (event == null) {
				
				event = new MpiEvent();
				event.setCorrelationId(id.getCorrelationId());
				event.setCreatedDate(date);
			}
			event.setId(id.getId());
			event.setUserId(userId);
			event.setEventType(data.getType());
			event.setStatus(TracingStatusType.inprogress.toString());
		}
		event.setModifiedDate(date);
		Trace trace = new Trace();
		
		trace.serializeTraceData(data);
		trace.setDirection(direction);
		trace.setStatus(TracingStatusType.inprogress.toString());
		trace.setCreatedDate(date);
		trace.setModifiedDate(date);
		event.addTrace(trace);
		return traceRepository.save(trace);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#updateTraceStatus(java.lang.Long, java.lang.String)
	 */
	@Override
	public void updateTraceStatus(Long traceId, String status) {
		Trace trace = traceRepository.findOne(traceId);
		trace.setStatus(status);
		trace.setModifiedDate(new Date());
		traceRepository.save(trace);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#updateTraceStatus(java.lang.Long, java.lang.String, boolean)
	 */
	@Override
	public void updateTraceStatus(Long traceId, String status, 
        boolean synchronizeEventStatus)
	{
		updateTraceStatus(traceId, status, null, null, synchronizeEventStatus);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#updateTraceStatus(java.lang.Long, java.lang.String, java.lang.Object, java.lang.String, boolean)
	 */
	@Override
	public void updateTraceStatus(Long traceId, String status, Object statusObj, 
        String correlationId, boolean synchronizeEventStatus)
	{
		updateTraceStatus(traceId, status, statusObj, correlationId, null, 
            synchronizeEventStatus);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#updateTraceStatus(java.lang.Long, java.lang.String, java.lang.Object, java.lang.String, java.lang.Long, boolean)
	 */
	@Override
	public void updateTraceStatus(Long traceId, String status, Object statusObj, 
        String correlationId, Long userId, boolean synchronizeEventStatus)
	{
		Trace trace = traceRepository.findOne(traceId);
		trace.setStatus(status);
		if (statusObj != null) {
			trace.serializeStatusData(statusObj);
		}
		trace.setModifiedDate(new Date());
		if (synchronizeEventStatus || (correlationId != null) 
            || (userId != null)) 
        {	
			MpiEvent event = trace.getEvent();
			if (synchronizeEventStatus) {
				event.setStatus(status);
            }
			if (correlationId != null) {
				event.setCorrelationId(correlationId);
            }
			if (userId != null) {
				event.setUserId(userId);
            }
			event.setModifiedDate(new Date());
			mpiEventsRepository.save(event);
		}
		traceRepository.save(trace);	
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.main.service.impl.EventTracingService#updateEventStatus(java.lang.Long, java.lang.String)
	 */
	@Override
	public void updateEventStatus(Long eventId, String status)
	{
		MpiEvent event = mpiEventsRepository.findOne(eventId);
		event.setStatus(status);
		event.setModifiedDate(new Date());
		mpiEventsRepository.save(event);
	}
	
}
